/*Tworzenie bazy danych WirtualnySklep*/
CREATE DATABASE WirtualnySklep
GO

/*Wybieranie bazy danych WirtualnySklep*/
Use WirtualnySklep
GO

/*Tworzenie tabeli tKlienci w bazie danych WirtualnySklep*/
CREATE TABLE tKlienci 
  (
    KlientID int NOT NULL,
    Nazwisko varchar (30) NOT NULL,
    Imie varchar (20) NOT NULL,
    Ulica varchar (30) NOT NULL,
    KodPocztowy char (6) NOT NULL,
    Miejscowosc varchar (30) NOT NULL,
    Wojewodztwo char (20) NOT NULL,
    Telefon char (15) NOT NULL,
    Email varchar (30) NOT NULL 
  )
GO

/*Tworzenie klucza podstawowego dla tabeli tKlienci w bazie danych WirtualnySklep*/
ALTER TABLE tKlienci WITH NOCHECK ADD CONSTRAINT PK_tKlienci PRIMARY KEY CLUSTERED 
  (
    KlientID
  )
GO

/*Tworzenie tabeli tProdukty w bazie danych WirtualnySklep*/
CREATE TABLE tProdukty
  (
    ProduktID int NOT NULL PRIMARY KEY,
    NazwaProduktu varchar (50) NOT NULL,
    OpisProduktu varchar (128) NOT NULL,
    TypProduktu varchar (30) NOT NULL,
    CenaProduktu smallmoney NOT NULL
  ) 
GO

/*Tworzenie tabeli tZamowienia w bazie danych WirtualnySklep*/
CREATE TABLE tZamowienia
  (
    ZamowienieID int NOT NULL PRIMARY KEY,
    KlientID int NOT NULL,
    DataZamowienia smalldatetime NOT NULL,
    DataTransportu smalldatetime NOT NULL,
    DataWystawieniaRachunku smalldatetime NOT NULL,
    DataZaplaty smalldatetime NOT NULL,
    StatusProduktu char (10) NOT NULL,
    StatusRachunku char (10) NOT NULL,
    RodzajTransportu char (10) NOT NULL,
    SumaPosrednia smallmoney NOT NULL,
    Rabat int NOT NULL,
    Podatek int NOT NULL,
    OplataTransportowa smallmoney NOT NULL,
    RazemDoZaplaty smallmoney NOT NULL
   )
GO

/*Tworzenie relacji pomidzy tabelami tZamowienia a tKlienci w bazie danych WirtualnySklep*/
ALTER TABLE tZamowienia ADD CONSTRAINT FK_tZamowienia_tKlienci FOREIGN KEY
  (
    KlientID
  ) 
  REFERENCES tKlienci
    (
      KlientID
    ) ON UPDATE CASCADE
GO

/*Tworzenie tabeli tElementyZamowienia w bazie danych WirtualnySklep*/
CREATE TABLE tElementyZamowienia 
  (
    ElementyZamowieniaID int NOT NULL PRIMARY KEY,
    ZamowienieID int NOT NULL,
    ProduktID int NOT NULL,
    NumerPorzadkowy int NOT NULL,
    Cena smallmoney NOT NULL,
    Rabat int NOT NULL,
    Ilosc int NOT NULL,
    Razem smallmoney NOT NULL
  )
GO

/*Tworzenie relacji pomidzy tabelami tElementyZamowienia a tProdukty w bazie danych WirtualnySklep*/
ALTER TABLE tElementyZamowienia ADD CONSTRAINT FK_tElementyZamowienia_tProdukty FOREIGN KEY 
  (
    ProduktID
  ) 
  REFERENCES tProdukty
    (
      ProduktID
    ) ON UPDATE CASCADE
GO

/*Tworzenie relacji pomidzy tabelami tElementyZamowienia a tZamowienia w bazie danych WirtualnySklep*/
ALTER TABLE tElementyZamowienia ADD CONSTRAINT FK_tElementyZamowienia_tZamowienia FOREIGN KEY 
  (
    ZamowienieID
  ) 
  REFERENCES tZamowienia
    (
      ZamowienieID
    ) ON UPDATE CASCADE
GO